<?php

class NdtController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        if (!Csrf::isTokenValid()) {
          //redirect to forbidden and exit
          header('HTTP/1.0 403 Forbidden', true, 403);
          exit();
        }
        $this->user=Auth::isAuthenticated();
    }

    /**
     * Handles what happens when user moves to URL/index/index - or - as this is the default controller, also
     * when user moves to /index or enter your application at base level
     */
    public function index()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $this->View->render('ndt/index', array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'vehicleid' => $vehicleid,
            'classes' => HmsModel::getAllVehicleClasses()
        ));
    }

    public function ndtupload()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('ndt/index');
        $permissions=RoleModel::getPermissionsForRole($role);
        if($permissions[$vehicleid."_NDT Upload_Submit"]["granted"])$files[]='ndt/ndtupload';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'vehicleid' => $vehicleid,
            'schedules' => HmsModel::getInspectionIntervalsMap($vehicleid),
            'classes' => HmsModel::getAllVehicleClasses(),
            'username' => $this->user->{'cognito:username'}
        ),'header');
    }

    public function ndtanalysis()
    {
        $role=RoleModel::getUserRole($this->user->{'cognito:username'});

        $vehicleid=Session::get('vehicleid');
        $files=array('ndt/index');
        $permissions=RoleModel::getPermissionsForRole($role);

        if($permissions[$vehicleid."_NDT Analysis_View/Search"]["granted"])$files[]='ndt/ndtanalysis';
        $this->View->renderMultiSpecial($files, array(
            'permissions' => RoleModel::getPermissionsForRole($role),
            'vehicleid' => $vehicleid,
            'classes' => HmsModel::getAllVehicleClasses(),
            'username' => $this->user->{'cognito:username'}
        ),'header');
    }

    public function getNdtResults()
    {
        $vehicleid=Session::get('vehicleid');
        $vrn=Validate::string(Request::post('vrn'));
        $date=Validate::date(Request::post('date'));
        $this->View->renderWithoutHeaderAndFooter('ndt/ajax/ndtresults', array(
           'data' => NdtModel::getNdtResults($vehicleid,$vrn,$date)
        ));
    }

    public function getInspectionRecordIds()
    {
        $vehicleid=Session::get('vehicleid');
        $vrn=Validate::string(Request::post('vrn'));
        $date=Validate::date(Request::post('date'));
        $results=NdtModel::getInspectionRecordIds($vehicleid,$vrn,$date);
        echo json_encode($results);
    }

    public function getSSIIdByInspectionRecord()
    {
        $vehicleid=Session::get('vehicleid');
        $recordid=Validate::string(Request::post('recordid'));
        $results=NdtModel::getSSIIdByInspectionRecord($vehicleid,$recordid);
        echo $results;
    }

    public function setHasScans()
    {
        $username=Validate::string(Request::post('username'));
        $recordid=Validate::string(Request::post('recordid'));
        $ssiid=Validate::string(Request::post('ssiid'));
        $filename=Validate::string(Request::post('filename'));
        $size=Validate::int(Request::post('size'));
        $results=NdtModel::setHasScans($username,$recordid,$ssiid,$filename,$size);
        echo $results;
    }

    public function getNDTUploads()
    {
        $recordid=Validate::string(Request::post('recordid'));
        $ssiid=Validate::string(Request::post('ssiid'));
        $results=NdtModel::getNDTUploads($recordid,$ssiid);
        echo $results;
    }

    public function analysisUpload()
    {
        $directory="NDT/";
        $postdata=$_POST;
        $results=NdtModel::insertNdtData($postdata,$directory);
        echo json_encode($results);
    }

    public function deleteNDTRecord()
    {
       $id=Validate::int(Request::post('id'));
       $results=NdtModel::deleteNDTRecord($id);
       echo json_encode($results);
    }
}


